% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingBayes.R
\name{mixing_posterior_check}
\alias{mixing_posterior_check}
\title{Model calibration plots}
\usage{
mixing_posterior_check(object, params, priors, fcol = "markers")
}
\arguments{
\item{object}{A valid object of class \code{MSnset}}

\item{params}{A valid object of class \code{MCMCParams} that has been processed
and checked for convergence}

\item{priors}{The prior that were used in the model}

\item{fcol}{The columns of the feature data which contain the marker data.}
}
\value{
Used for side effect of producing plot. Invisibily returns an ggplot object
that can be further manipulated
}
\description{
Model calibration model with posterior z-scores and posterior shrinkage
}
\examples{
\dontrun{
library("pRoloc")
data("tan2009r1")

tanres <- tagmMcmcTrain(object = tan2009r1)
tanres <- tagmMcmcProcess(tanres)
tan2009r1 <- tagmMcmcPredict(object = tan2009r1, params = tanres, probJoint = TRUE)
myparams <- chains(e14Tagm_converged_pooled)[[1]]
myparams2 <- chains(mcmc_pool_chains(tanres))[[1]]
priors <- tanres@priors
pRoloc:::mixing_posterior_check(object = tan2009r1, params = myparams2, priors = priors)
}
}
\author{
Oliver M. Crook <omc25@cam.ac.uk>
}
