% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f1ScoreVoting.R
\name{f1ScoreVoting}
\alias{f1ScoreVoting}
\title{f1ScoreVoting}
\usage{
f1ScoreVoting(voting, clustering, cytometry, nivel_sup, noise.cells)
}
\arguments{
\item{voting}{A list where each entry is a vote on the respective label.}

\item{clustering}{Labels of the partition.}

\item{cytometry}{Data of the clustering, where the last variable contains the original labels.}

\item{nivel_sup}{level of tolerance for assigning a hard clustering. Should be greater or equal than 1. Class A is assigned if class A > nivel_sup * Class B.}

\item{noise.cells}{An array of labels to be considered as noise.}
}
\value{
A matrix where the first row is the F1 score, the second row is the Precision and the third row is the Recall.
}
\description{
Calculates the F1 score fore each group in a partition, when provided with a fuzzy classification.
}
\examples{
# # We construct a simple database selecting only some of the Cytometries and some cell types for simplicity and for a better visualisation.
database <- buildDatabase(
  dataset_names = paste0('Cytometry', c(2:5, 7:9, 12:17, 19, 21)),
    population_ids = c('Monocytes', 'CD4+CD8-', 'Mature SIg Kappa', 'TCRgd-'))

templates.optimalFlow <- optimalFlowTemplates(database = database, templates.number = 5,
cl.paral = 1)

classification.optimalFlow <- optimalFlowClassification(as.data.frame(Cytometry1)[
 which(match(Cytometry1$`Population ID (name)`, c('Monocytes', 'CD4+CD8-',
                                                 'Mature SIg Kappa', 'TCRgd-'), nomatch = 0) > 0), 1:10], database, templates.optimalFlow,
 classif.method = 'matching', cost.function = 'ellipses', cl.paral = 1)

f1ScoreVoting(classification.optimalFlow$cluster.vote, classification.optimalFlow$cluster,
              as.data.frame(Cytometry1)[which(match(Cytometry1$`Population ID (name)`,
                                                    c('Monocytes', 'CD4+CD8-', 'Mature SIg Kappa', 'TCRgd-'), nomatch = 0) > 0), ], 1.01, noise.types)
}
