% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_coverage.R
\name{get_cvg_stats,list-method}
\alias{get_cvg_stats,list-method}
\title{Coverage Statistics for Multiple Primer Sets.}
\usage{
\S4method{get_cvg_stats}{list}(
  primers,
  templates,
  for.viewing = FALSE,
  total.percentages = FALSE,
  allowed.mismatches = Inf,
  cvg.definition = c("constrained", "basic")
)
}
\arguments{
\item{primers}{A list with objects of class \code{Primers} containing
primers with evaluated coverage.}

\item{templates}{A list with objects of class \code{Templates} containing
templates with evaluated coverage.}

\item{for.viewing}{Whether the table should be formatted
for viewing rather than processing.}

\item{total.percentages}{Whether group coverage percentages
should relate to all template sequences or just those templates
belonging to a specific group.}

\item{allowed.mismatches}{The maximal allowed number of mismatches.
By default, the number of mismatches is not restricted.}

\item{cvg.definition}{If \code{cvg.definition} is set to
"constrained", the statistics for the expected
coverage (after applying the coverage constraints) are retrieved.
If \code{cvg.definition} is set to "basic", the coverage is determined 
solely by string matching (i.e. without applying the coverage constraints).
By default, \code{cvg.definition} is set to "constrained".}
}
\value{
Data frame with coverage statistics.
}
\description{
Retrieve statistics on covered templates for multiple primer sets.
}
\keyword{internal}
