% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{create_report,list,list-method}
\alias{create_report,list,list-method}
\title{Creation of a PDF Report for Primer Comparison.}
\usage{
\S4method{create_report}{list,list}(
  primers,
  templates,
  fname,
  settings,
  sample.name = NULL,
  used.settings = NULL
)
}
\arguments{
\item{primers}{A list with evaluated \code{Primers} objects.}

\item{templates}{A list with \code{Templates} objects.}

\item{fname}{A character vector giving the file to store the report in.}

\item{settings}{A \code{DesignSettings} object.}

\item{sample.name}{An identifier for your analysis.}

\item{used.settings}{A named list (with fields "fw" and "rev") containing the forward/reverse used design settings.}
}
\value{
Creates a PDF file giving a report on the comparison of the input primers.
}
\description{
Creates a PDF report for comparing multiple primers.
}
\note{
Creating the report requires the external programs Pandoc (http://pandoc.org)
and LateX (http://latex-project.org).
}
\keyword{internal}
