% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mindensity2.R
\name{gate_mindensity2}
\alias{gate_mindensity2}
\alias{mindensity2}
\title{An improved version of mindensity used to determines a cutpoint as the minimum point 
of a kernel density estimate between two peaks.}
\usage{
gate_mindensity2(
  fr,
  channel,
  filterId = "",
  gate_range = NULL,
  min = NULL,
  max = NULL,
  peaks = NULL,
  ...
)
}
\arguments{
\item{fr}{a \code{flowFrame} object}

\item{channel}{the channel to operate on}

\item{filterId}{a name to refer to this filter}

\item{gate_range}{numeric vector of length 2. If given, this sets the bounds
on the gate applied.}

\item{min}{a numeric value that sets the lower boundary for data filtering}

\item{max}{a numeric value that sets the upper boundary for data filtering}

\item{peaks}{\code{numeric} vector. If not given , then perform peak detection first by .find_peaks}

\item{...}{Additional arguments for peak detection.}
}
\value{
a \code{rectangleGate} object based on the minimum density cutpoint
}
\description{
Analogous to the original openCyto::mindensity(), mindensity2 operates on a standard flowFrame. Its behavior is closely modeled on 
the original mindensity() whenever possible. However, the underlying peak-finding algorithm 
(improvedMindensity) behaves significantly differently.
}
\examples{
\dontrun{
 gate <- gate_mindensity2(fr, channel = "APC-A") # fr is a flowFrame
}
}
\author{
Greg Finak, Phu T. Van
}
