% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owl2cache.R
\name{owl2cache}
\alias{owl2cache}
\title{cache an owl file accessible via URL}
\usage{
owl2cache(cache = BiocFileCache::BiocFileCache(), url)
}
\arguments{
\item{cache}{BiocFileCache instance or equivalent}

\item{url}{character(1)}
}
\description{
cache an owl file accessible via URL
}
\note{
This function will check for presence of url in cache using bfcquery; 
if a hit is found, returns the rpath associated with the last
matching record.  etags can be available for use with bfcneedsupdate.
}
\examples{
ca = BiocFileCache::BiocFileCache()
o2 = try(reticulate::import("owlready2"), silent=TRUE)
if (!inherits(o2, "try-error")) {
 hppa = owl2cache(ca, 
    url="http://purl.obolibrary.org/obo/hp/releases/2023-10-09/hp-base.owl")
 setup_entities(hppa)
}
}
