% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapNaive.R
\name{liberalMap}
\alias{liberalMap}
\title{Produce a data.frame with a set of naive terms mapped to all matching ontology ids and their formal terms}
\usage{
liberalMap(terms, onto, useAgrep = FALSE, ...)
}
\arguments{
\item{terms}{character() vector, can use grep-compatible regular expressions}

\item{onto}{an instance of ontologyIndex::ontology_index}

\item{useAgrep}{logical(1) if TRUE, agrep will be used}

\item{\dots}{passed to agrep if used}
}
\value{
a data.frame
}
\description{
Produce a data.frame with a set of naive terms mapped to all matching ontology ids and their formal terms
}
\examples{
cands = c("astrocyte$", "oligodendrocyte", "oligodendrocyte precursor",
   "neoplastic", "^neuron$", "^vascular", "badterm")
#co = ontoProc::getCellOnto()
co = getOnto("cellOnto", year_added="2023")
liberalMap(cands, co)
}
