% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCommonAncestors.R
\name{findCommonAncestors}
\alias{findCommonAncestors}
\title{Find common ancestors}
\usage{
findCommonAncestors(..., g, remove.self = TRUE, descriptions = NULL)
}
\arguments{
\item{...}{One or more (possibly named) character vectors containing ontology terms.}

\item{g}{A \link{graph} object containing the hierarchy of all ontology terms.}

\item{remove.self}{Logical scalar indicating whether to ignore ancestors containing only a single term (themselves).}

\item{descriptions}{Named character vector containing plain-English descriptions for each term.
Names should be the term identifier while the values are the descriptions.}
}
\value{
A \linkS4class{DataFrame} where each row corresponds to a common ancestor term.
This contains the columns \code{number}, the number of descendent terms across all vectors in \code{...};
and \code{descendents}, a \linkS4class{List} of DataFrames containing the identities of the descendents.
It may also contain the column \code{description}, containing the description for each term.
}
\description{
Given a set of ontology terms, find their latest common ancestors based on the term hierarchy.
}
\details{
This function identifies all terms in \code{g} that are the latest common ancestor (LCA) of any subset of terms in \code{...}.
An LCA is one that has no children that have the exact same set of descendent terms in \code{...},
i.e., it is the most specific term for that set of observed descendents.
Knowing the LCA is useful for deciding how terms should be rolled up to broader definitions in downstream applications,
usually when the exact terms in \code{...} are too specific for practical use.

The \code{descendents} DataFrame in each row of the output describes the descendents for each LCA,
stratified by their presence or absence in each entry of \code{...}.
This is particularly useful for seeing how different sets of terms would be aggregated into broader terms,
e.g., when harmonizing annotation from different datasets or studies.
Note that any names for \code{...} will be reflected in the columns of the DataFrame for each LCA.
}
\examples{
co <- getOnto("cellOnto")

# TODO: wrap in utility function.
parents <- co$parents
self <- rep(names(parents), lengths(parents))
library(igraph)
g <- make_graph(rbind(unlist(parents), self))

# Selecting random terms:
LCA <- ontoProc:::findCommonAncestors(A=sample(names(V(g)), 20),
   B=sample(names(V(g)), 20), g=g)

LCA[1,]
LCA[1,"descendents"][[1]]

}
\author{
Aaron Lun
}
