% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ompBAM.R
\name{example_BAM}
\alias{example_BAM}
\title{Returns the path of a test BAM file}
\usage{
example_BAM(dataset = c("Unsorted", "scRNAseq"))
}
\arguments{
\item{dataset}{Returns the path to either the "Unsorted" or "scRNAseq" BAM.}
}
\value{
A file path to the specified BAM file.
}
\description{
Two types of BAM files are available. "Unsorted" is an unsorted BAM file of
paired RNA-seq of THP1 cell culture from Green et al (GSE130011, GSM3729250),
truncated to the first 10k reads. "scRNAseq" is a single cell 10X chromium V2
BAM file (sorted). It is sample E3.5_Rep1 from Nowotschin et al 
(GSE123046 / GSM3494334), truncated to the first 50k reads.
}
\examples{
example_BAM("Unsorted")
}
