% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxi_databaseFormat.R
\name{readESVObj}
\alias{readESVObj}
\title{Read the object of SummarizedExperiment or ExpressetSet to be visualized using omicsViewer}
\usage{
readESVObj(x)
}
\arguments{
\item{x}{the path of an object of \code{SummarizedExperiment} or \code{ExpressionSet}, passed to \link{readRDS}}
}
\value{
an object of class \code{ExpressionSet} or \code{SummarizedExperiment} to be visualzied.
}
\description{
This function accept a path to a sqlite database or RDS object. If an RDS file to be read, 
  The function is similar to \code{readRDS}. It reads the object to R working environment and perform extra two things. 
  1. If the loaded data an class of \code{SummarizedExperiment}, it will be converted to \code{ExpressionSet};
  2. If the gene set annotatio is in matrix format, the gene set annotation is converted to \code{data.frame} format.
}
\examples{
file <- system.file("extdata/demo.RDS", package = "omicsViewer")
obj <- readESVObj(file)

}
