% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotyping.R
\name{alleleSharing}
\alias{alleleSharing}
\title{allele sharing based on ibs}
\usage{
alleleSharing(x, y = NULL, relations = NULL, idx.col = "idx",
  idy.col = "idy", rel.col = "relation_type", callRate = 0.95,
  coverageRate = 2/3, alpha = 0, maf = 0, alignment = FALSE,
  assayNameX = NULL, assayNameY = NULL, verbose = TRUE)
}
\arguments{
\item{x, y}{genotype matrix with row and column names; if this is a
SummarizedExperiment or a MultiAssayExperiment assayName must
also be specified}

\item{relations}{'data.frame' with relations and their mapping
identifiers, provide columns if different from the default and
beware identifiers should match with colnames of x and y}

\item{idx.col}{column name containing mapping identifiers}

\item{idy.col}{column name containing mapping identifiers}

\item{rel.col}{column name containing the relations,
i.e. identical, parentoffspring, etc.}

\item{callRate}{default 0.95 SNPs that are called in less then the
threshold are dropped}

\item{coverageRate}{default 2/3 samples with less then threshold
SNPs called are set to NA}

\item{alpha}{significance level for Hardy-Weinberg test default alpha = 0,
no filtering, internaly Bonferonni multiple testing will be applied}

\item{maf}{minor allele frequency threshold,
variants with lower frequency (default 0 no filtering) will be dropped}

\item{alignment}{default FALSE}

\item{assayNameX}{the name of the assay to be used for x (see x, y)}

\item{assayNameY}{same as assayNameX, but for y; if y is not
specified, the assay will be retreived from x}

\item{verbose}{show progress default TRUE}
}
\value{
data.frame with mean and variance ibs between all pairs
}
\description{
Run the allele sharing algorithm based on ibs
}
\details{
calculate mean and variance of identity by state between
genotypes, coded as 1,2,3, of all sample pairs either give one
omic inferred set of SNPs or two from different omic types.

'Strand Alignment' is required if methylation data inferred genotypes are
compared with DNA based genotypes, i.e., DNA based genotype is 3
whereas methylation is 1. The strand alignment step will fix this.

Notice that there are two algorithms for calculating allele
sharing. One for the case one matrix is provided and one for the
case two, x and y, are provided. If one is provided the algorithm
takes in account the symmetric relations between pairs i.e. x12 =
x21 etc.

To improve the lookup of relations, which can be millions of say
1000 samples are provided, a hash-table is created from the
provided data.frame with relations.
}
\examples{
set.seed(12345)
beta <- matrix(runif(100*10, 0,1), nrow=100)
beta[1:5, 1:5]
colnames(beta) <- paste0("sample", 1:10)
genotype <- beta2genotype(beta)
genotype[1:5, 1:5]
data <- alleleSharing(genotype)
head(data)
}
\author{
mvaniterson
}
