% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/ResultSet-plotHits.R
\docType{methods}
\name{plotHits}
\alias{plotHits}
\alias{plotHits,ResultSet-method}
\alias{plotHits}
\title{Plot number of hits per result in ResultSet}
\usage{
plotHits(object, th = 0.05, width = 0.75)

\S4method{plotHits}{ResultSet}(object, th = 0.05, width = 0.75)
}
\arguments{
\item{object}{An object of class \link{ResultSet}}

\item{th}{(default \code{0.05}) Threshold (p-value) to considere a result
as a hit.}

\item{width}{(default \code{0.70}) width of the bar}
}
\value{
A ggplot2 object
}
\description{
This method draws a barplot with the number of hits in each result
stored in the given \link{ResultSet}.
}
\examples{
data(asr, package = "omicRexposome")
plotHits(asr)
}
\seealso{
\code{\link{plotLambda}} for a graphical representation of
the lambda score per analysys, \code{\link{tableLambda}} for the lambda
score per analysys, \code{\link{tableHits}} for the hists per analysys
}
