% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/MultiDataSet-crossomics.R
\docType{methods}
\name{crossomics}
\alias{crossomics}
\alias{crossomics,MultiDataSet-method}
\alias{crossomics}
\title{Function to perform a Transcriptome-Wide Association Study}
\usage{
crossomics(object, method = "mcca", ncomponents = 2, ..., na.rm = FALSE,
  permute = c(100, 3), verbose = FALSE, warnings = TRUE)

\S4method{crossomics}{MultiDataSet}(object, method = "mcca",
  ncomponents = 2, ..., na.rm = FALSE, permute = c(100, 3),
  verbose = FALSE, warnings = TRUE)
}
\arguments{
\item{object}{A \code{MultiDataSet} object containing at last two data-sets
like \code{ExposomeSet}, \code{ExpressionSet}, \code{MethylationSet}...}

\item{method}{(default \code{"mcca"}) It can takes values \code{"mcca"} for
Multiple Canonical Correlation Analysis or \code{"mcia"} for Multiple
Co-Inertia Analysis.}

\item{ncomponents}{(default \code{2}) Number of components to be estimated.}

\item{...}{Other arguments given to \code{mcia} (from \code{omicade4}) or
to \code{MultiCCA} (from \code{PMA}).}

\item{na.rm}{(default \code{FALSE}) If \code{method} was set to
\code{"mcca"} and \code{na.rm} was set to \code{TRUE}, features containing
missing values are removed.}

\item{permute}{(default \code{c(100, 3)}). If \code{method="mcca"} and this
agument is set to \code{NULL} no permutation test to tune-up the parameters
for \code{MultiCCA}. When filles, \code{permute[1]} corresponds to
the number permutations (default in \code{MultiCCa.permute} is \code{25})
and \code{permute[2]} the number of iterations
(default in \code{MultiCCA.permute} is 3).}

\item{verbose}{(default \code{FALSE}) If set to \code{TRUE}, a series of
messages descriving the process are shown.}

\item{warnings}{(default \code{TRUE}) If set to \code{TRUE}, a series of
warnings are shown when required user atention.}
}
\value{
An object of class \code{\link{ResultSet}}.
}
\description{
This function allows to perform a Transcriptome-Wide Association Study
by using an \code{ExposmeSet} and an \code{ExpressionSet}. It
allows to perform an adjustment using Surrogate Variable Analysis (from
R package \code{sva}).
}
\examples{
library(MultiDataSet)
library(rexposome)
data(brge_prot, package = "brgedata")
data(brge_expo, package = "brgedata")
mds <- createMultiDataSet()
mds <- add_eset(mds, brge_prot, dataset.type = "proteines")
mds <- add_eset(mds, imputation(brge_expo),
    dataset.type = "exposures", GRanges = NA)

crs <- crossomics(mds, method = "mcia")
crs
}
