% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_visualizations.R
\name{plot_sample_boxplots}
\alias{plot_sample_boxplots}
\title{Plot a boxplot for each sample}
\usage{
plot_sample_boxplots(
  object,
  all_features = FALSE,
  order_by,
  fill_by,
  title = "Boxplot of samples",
  subtitle = NULL,
  fill_scale = getOption("notame.fill_scale_dis"),
  zoom_boxplot = TRUE,
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{order_by}{character vector, names of columns used to order the samples}

\item{fill_by}{character vector, names of columns used to fill the boxplots}

\item{title, subtitle}{character, title and subtitle of the plot}

\item{fill_scale}{a scale for the fill of the boxplots, as returned by a 
ggplot function}

\item{zoom_boxplot}{logical, whether outliers should be left outside the 
plot and only the boxplots shown. Defaults to TRUE.}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A ggplot object.
}
\description{
Plots a boxplot of the distribution of the metabolite values for each 
sample. The boxplots can be ordered and filled by any combination of columns 
in the pheno data. By default, order and fill are both determined by the 
combination of group and time columns.
}
\examples{
data(toy_notame_set, package = "notame")
plot_sample_boxplots(toy_notame_set, order_by = "Group", fill_by = "Group")

}
