% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{mz_rt_plot}
\alias{mz_rt_plot}
\title{Plot m/z vs retention time plot (cloud plot)}
\usage{
mz_rt_plot(
  object,
  p_col = NULL,
  p_limit = NULL,
  mz_col = NULL,
  rt_col = NULL,
  color = NULL,
  title = "m/z vs retention time",
  subtitle = NULL,
  color_scale = getOption("notame.color_scale_con"),
  all_features = FALSE,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object or a data frame. Feature data is used. If x 
is a data frame, it is used as is.}

\item{p_col}{the column name containing p-values. This is used to scale the 
size of the points.}

\item{p_limit}{numeric, limits plotted features by p-values. If NULL, plots 
all features.}

\item{mz_col, rt_col}{the column names for m/z and retention time. If NULL, 
automatic detection is attempted.}

\item{color}{the column name used to color the points}

\item{title}{The plot title}

\item{subtitle}{The plot subtitle}

\item{color_scale}{color scale as returned by a ggplot function. Defaults to 
current continuous color scale.}

\item{all_features}{logical, should all features be retained? Should be used 
only if x is a SummarizedExperiment object.}

\item{...}{parameters passed to \code{\link[ggplot2]{geom_point}},
such as shape and alpha values. New aesthetics can
also be passed using \code{mapping = aes(...)}.}
}
\value{
A ggplot object.
}
\description{
Plots a scatter plot of results of statistical tests, where each point 
represents a feature. The plot has retention time on x-axis, m/z on y-axis 
and the size of the points is scaled based on p-value
}
\examples{
data(toy_notame_set, package = "notame")
# Compute results from a linear model
lm_results <- notameStats::perform_lm(toy_notame_set,
  formula_char = "Feature ~ Group")
with_results <- notame::join_rowData(toy_notame_set, lm_results)

# Plot from the SummarizedExperiment object
# automatically facet by analytical mode in variable Split
mz_rt_plot(with_results, p_col = "GroupB.p.value", color = "GroupB.estimate")

# Plot the results from the results dataframe
lm_data <- dplyr::left_join(as.data.frame(rowData(toy_notame_set)), 
                            lm_results)
mz_rt_plot(lm_data, p_col = "GroupB.p.value", color = "GroupB.estimate")

}
