% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_plots.R
\name{save_subject_line_plots}
\alias{save_subject_line_plots}
\title{Save line plots with mean}
\usage{
save_subject_line_plots(
  object,
  all_features = FALSE,
  save = TRUE,
  file_path = NULL,
  format = "emf",
  x,
  id,
  title = "Feature_ID",
  subtitle = NULL,
  color = NULL,
  color_scale = getOption("notame.color_scale_dis"),
  facet = NULL,
  text_base_size = 14,
  line_width = 0.3,
  mean_line_width = 1.2,
  title_line_length = 40,
  theme = theme_bw(base_size = text_base_size),
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{all_features}{logical, should all features be used?
If FALSE (the default), flagged features are removed before visualization.}

\item{save}{logical, if false, the plots are not saved but returned as a list}

\item{file_path}{character, a file path for PDF or prefix added to the file 
paths for other formats}

\item{format}{character, format in which the plots should be saved}

\item{x}{character, name of the column to be used as x-axis}

\item{id}{character, name of the column containing subject IDs}

\item{title, subtitle}{column names from feature data to use as plot 
title/filename and subtitle.
Set to NULL for no title/subtitle, this creates running numbered filenames}

\item{color}{character, the column name to color the lines by (optional)}

\item{color_scale}{the color scale as returned by a ggplot function}

\item{facet}{character, the column name to facet by (optional, usually same 
as color)}

\item{text_base_size}{integer, base size for text in figures}

\item{line_width}{numeric, width of the lines}

\item{mean_line_width}{numeric, width of the mean line}

\item{title_line_length}{integer, maximum length of the title line in 
characters, passed to \code{\link[stringr]{str_wrap}}}

\item{theme}{a ggplot theme to be added to the plot}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{other arguments to graphic device functions, like width and height}
}
\value{
By default, the function is invoked for its plot-saving side effect. 
The function returns a list of plots when \code{save = FALSE}.
}
\description{
Plots the change in the feature abundances as a function of e.g. time.
A line is drawn for each subject and a mean line is added.
A separate plot is drawn and saved for each feature.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(toy_notame_set, package = "notame")
save_subject_line_plots(notame::drop_qcs(toy_notame_set)[1:10], x = "Time", 
  id = "Subject_ID", file_path = "./subject_line_plots.pdf",
  format = "emf", title = NULL)

# Plot one feature
save_subject_line_plots(notame::drop_qcs(toy_notame_set[1, ]), save = FALSE,
  x = "Time", id = "Subject_ID")
\dontshow{setwd(.old_wd)}

}
\seealso{
\code{\link{save_plot}}
}
