% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{plot_pca}
\alias{plot_pca}
\title{PCA scatter plot}
\usage{
plot_pca(
  object,
  pcs = c(1, 2),
  all_features = FALSE,
  center = TRUE,
  scale = "uv",
  color = NULL,
  shape = color,
  label = NULL,
  density = FALSE,
  title = "PCA",
  subtitle = NULL,
  color_scale = NA,
  shape_scale = getOption("notame.shape_scale"),
  fill_scale = getOption("notame.fill_scale_dis"),
  text_base_size = 14,
  point_size = 2,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{pcs}{numeric vector of length 2, the principal components to plot}

\item{all_features}{logical, should all features be used? If FALSE (the 
default), flagged features are removed before visualization.}

\item{center}{logical, should the data be centered prior to PCA? (usually 
yes)}

\item{scale}{scaling used, as in \code{\link[pcaMethods]{prep}}. Default is 
"uv" for unit variance}

\item{color}{character, name of the column used for coloring the points. Set 
to NULL for black color.}

\item{shape}{character, name of the column used for shape. Set to NULL for 
uniform round shapes.}

\item{label}{character, name of the column used for point labels}

\item{density}{logical, whether to include density plots to both axes.
The density curves will be split and colored by the 'color' variable.}

\item{title, subtitle}{the titles of the plot}

\item{color_scale}{the color scale as returned by a ggplot function. Set to 
NA to choose the appropriate scale based on the class of the coloring 
variable.}

\item{shape_scale}{the shape scale as returned by a ggplot function}

\item{fill_scale}{the fill scale used for density curves.
If a continuous variable is used as color, density curve will be colorless.}

\item{text_base_size}{numeric, base size for text}

\item{point_size}{numeric, size of the points}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional arguments passed to \code{\link[pcaMethods]{pca}}}
}
\value{
A ggplot object. If \code{density} is \code{TRUE}, the plot will 
consist of multiple parts and is harder to modify.
}
\description{
Computes PCA using one of the methods provided in the Bioconductor package
pcaMethods and plots the two first principal components.
}
\examples{
data(toy_notame_set, package = "notame")
plot_pca(toy_notame_set, color = "Injection_order", shape = "Group")

}
\seealso{
\code{\link[pcaMethods]{pca}}
}
