% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_lmer}
\alias{perform_lmer}
\title{Linear mixed models}
\usage{
perform_lmer(
  object,
  formula_char,
  all_features = FALSE,
  ci_method = c("Wald", "profile", "boot"),
  test_random = FALSE,
  assay.type = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{formula_char}{character, the formula to be used in the linear model 
(see Details)}

\item{all_features}{should all features be included in FDR correction?}

\item{ci_method}{The method for calculating the confidence intervals as in 
\code{\link{confint}}}

\item{test_random}{logical, whether tests for the significance of the random 
effects should be performed}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional parameters passed to \code{\link[lmerTest]{lmer}}}
}
\value{
A data frame with one row per feature, with all the
relevant statistics of the linear mixed model as columns.
}
\description{
Fits a linear mixed model separately for each feature. Returns all relevant
statistics.
}
\details{
The model is fit on combined_data(object). Thus, column names
in pheno data can be specified. To make the formulas flexible, the word 
"Feature" must be used to signal the role of the features in the formula. 
"Feature" will be replaced by the actual Feature IDs during model fitting, 
see the example. With bootstrap ("boot") confidence intervals, the results 
are reproducible if RNGseed is set for the BiocParallel backend.
}
\examples{
data(toy_notame_set, package = "notame")
# A simple example without QC samples
# Features predicted by Group and Time as fixed effects with Subject ID as a 
# random effect
lmer_results <- perform_lmer(notame::drop_qcs(toy_notame_set),
  formula_char = "Feature ~ Group + Time + (1 | Subject_ID)",
  ci_method = "Wald"
)
}
\seealso{
\code{\link[lmerTest]{lmer}} for model specification
}
