% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_lm}
\alias{perform_lm}
\title{Linear models}
\usage{
perform_lm(object, formula_char, all_features = FALSE, assay.type = NULL, ...)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{formula_char}{character, the formula to be used in the linear model 
(see Details)}

\item{all_features}{should all features be included in FDR correction?}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{...}{additional parameters passed to \code{\link{lm}}}
}
\value{
A data frame with one row per feature, with all the
relevant statistics of the linear model as columns.
}
\description{
Fits a linear model separately for each feature. Returns all relevant
statistics.
}
\details{
The linear model is fit on combined_data(object). Thus, column names
in pheno data can be specified. To make the formulas flexible, the word 
"Feature" must be used to signal the role of the features in the formula. 
"Feature" will be replaced by the actual Feature IDs during model fitting, 
see the example.
}
\examples{
data(toy_notame_set, package = "notame")
# A simple example without QC samples
# Features predicted by Group and Time
lm_results <- perform_lm(notame::drop_qcs(toy_notame_set), 
  formula_char = "Feature ~ Group + Time")

}
\seealso{
\code{\link[stats]{lm}}
}
