% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_homoscedasticity_tests}
\alias{perform_homoscedasticity_tests}
\title{Test homoscedasticity}
\usage{
perform_homoscedasticity_tests(
  object,
  formula_char,
  all_features = FALSE,
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{formula_char}{character, the formula to be used in the linear model 
(see Details)}

\item{all_features}{should all features be included in FDR correction?}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A data frame with the results.
}
\description{
Performs Bartlett's, Levene's and Fligner-Killeen tests for equality of 
variances.
}
\details{
The model is fit on combined_data(object). Thus, column names
in pheno data can be specified. To make the formulas flexible, the word 
"Feature" must be used to signal the role of the features in the formula. 
"Feature" will be replaced by the actual Feature IDs during model fitting. 
For example, if testing for equality of variances in study groups, use 
"Feature ~ Group".
}
\examples{
data(toy_notame_set, package = "notame")
perform_homoscedasticity_tests(toy_notame_set,
  formula_char = "Feature ~ Group")

}
\seealso{
\code{\link{bartlett.test}}, \code{\link[car]{leveneTest}}, 
\code{\link{fligner.test}}
}
