% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_genes.R
\name{filter_genes}
\alias{filter_genes}
\title{Preprocessing function to filter genes}
\usage{
filter_genes(
  spe,
  filter_genes_ncounts = 3,
  filter_genes_pcspots = 0.5,
  filter_mito = TRUE
)
}
\arguments{
\item{spe}{\code{SpatialExperiment}: Input data, assumed to be formatted as a
\code{SpatialExperiment} object with an \code{assay} slot named
\code{counts} containing raw expression counts.}

\item{filter_genes_ncounts}{\code{numeric}: Filtering parameter for
low-expressed genes. Filtering retains genes containing at least
\code{filter_genes_ncounts} expression counts in at least
\code{filter_genes_pcspots} percent of the total number of spatial
locations (spots). Defaults: \code{filter_genes_ncounts} = 3,
\code{filter_genes_pcspots} = 0.5, i.e. keep genes with at least 3 counts
in at least 0.5 percent of spots. Set to NULL to disable.}

\item{filter_genes_pcspots}{\code{numeric}: Second filtering parameter for
low-expressed genes. Set to NULL to disable. See
\code{filter_genes_ncounts} for details.}

\item{filter_mito}{\code{logical}: Whether to filter out mitochondrial genes,
identified by gene names starting with "MT" or "mt". This requires that the
\code{rowData} slot of the input object contains a column named
\code{gene_name}. Default = TRUE. Set to FALSE to disable.}
}
\value{
Returns \code{SpatialExperiment} with filtered genes (rows) removed.
}
\description{
Preprocessing function to filter low-expressed genes and/or mitochondrial
genes for 'nnSVG'.
}
\details{
Preprocessing function to filter low-expressed genes and/or mitochondrial
genes for 'nnSVG'.

This function can be used to filter out low-expressed genes and/or
mitochondrial genes before additional preprocessing (calculating logcounts or
deviance residuals) and running 'nnSVG'.

We use this function in the examples and vignettes in the 'nnSVG' package,
and provide default filtering parameter values that are appropriate for 10x
Genomics Visium data.

The use of this function is optional. Users can also perform filtering and
preprocessing separately, and run \code{\link{nnSVG}} on a preprocessed
\code{SpatialExperiment} object.
}
\examples{
library(SpatialExperiment)
library(STexampleData)

# load example dataset from STexampleData package
spe <- Visium_humanDLPFC()

# preprocessing steps

# keep only spots over tissue
spe <- spe[, colData(spe)$in_tissue == 1]
dim(spe)

# filter low-expressed and mitochondrial genes
spe <- filter_genes(spe)
dim(spe)

}
