% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection_plot.R
\name{projection_plot}
\alias{projection_plot}
\title{projection_plot}
\usage{
projection_plot(
  mcia_results,
  projection,
  orders = c(1, 2),
  block_name = NULL,
  color_col = NULL,
  color_pal = scales::viridis_pal,
  color_pal_params = list(option = "E"),
  legend_loc = "bottomleft",
  color_override = NULL,
  cex = 0.5
)
}
\arguments{
\item{mcia_results}{MCIA results object returned from `nipals_multiblock`}

\item{projection}{of plot, with the following options
\itemize{
\item `all` - scatter plot of two orders of global and block
              scores (aka factors).
\item `global` - scatter plot of two orders of global scores
                 only (aka factors).
\item `block` - scatter plot of two orders of block scores
                only (aka factors) for given block.
}}

\item{orders}{Option to select orders of factors to plot against each other
(for projection plots)}

\item{block_name}{Name of the block to be plotted (if `projection = block` argument used).}

\item{color_col}{an integer or string specifying the column that will be
used for color_col}

\item{color_pal}{a list of colors or function which returns a list of colors}

\item{color_pal_params}{a list of parameters for the color function}

\item{legend_loc}{Option for legend location, or "none" for no legend.}

\item{color_override}{Option to override colors when necessary, helpful for
projection = "global" or "block"}

\item{cex}{Resizing parameter for drawing the points}
}
\value{
Displays the desired plots
}
\description{
Function to generate a projection plot of MCIA results.
}
\details{
Plotting function for a projection plot.
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                  plots = "none", tol = 1e-12)
projection_plot(mcia_results, projection = "all", orders = c(1,2),
                color_col = "cancerType", legend_loc = "bottomright")
}
