% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colors.R
\name{get_colors}
\alias{get_colors}
\title{Assigning colors to different omics}
\usage{
get_colors(
  mcia_results,
  color_pal = scales::viridis_pal,
  color_pal_params = list()
)
}
\arguments{
\item{mcia_results}{object returned from nipals_multiblock() function}

\item{color_pal}{a function which returns color palettes (e.g. scales)}

\item{color_pal_params}{list of parameters for the corresponding function}
}
\value{
List of omics with assigned colors
}
\description{
Creates a list of omics and associated colors for plotting. The
default palette was chosen to be color-blindness friendly.
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                 plots = "none", tol = 1e-12)
colors_omics <- get_colors(mcia_results)
}
