% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTotals.R
\name{readTotals}
\alias{readTotals}
\title{Get the read totals}
\usage{
readTotals(x)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList}, \code{FastpData},
\code{FastpDataList} or file paths}
}
\value{
A \code{tibble} with the columns \code{Filename} and
\code{Total_Sequences}
}
\description{
Get the read totals from one or more FASTQC reports
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Print the read totals
readTotals(fdl)

}
