% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReadTotals.R
\docType{methods}
\name{plotReadTotals}
\alias{plotReadTotals}
\alias{plotReadTotals,ANY-method}
\alias{plotReadTotals,FastqcDataList-method}
\alias{plotReadTotals,FastpDataList-method}
\title{Draw a barplot of read totals}
\usage{
plotReadTotals(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotReadTotals}{ANY}(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotReadTotals}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  duplicated = TRUE,
  bars = c("stacked", "adjacent"),
  vertBars = TRUE,
  divBy = 1,
  barCols = c("red", "blue"),
  expand.y = c(0, 0.02),
  plotlyLegend = FALSE,
  ...
)

\S4method{plotReadTotals}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  adjPaired = TRUE,
  divBy = 1e+06,
  scaleFill = NULL,
  labMin = 0.05,
  status = TRUE,
  labelVJ = 0.5,
  labelFill = "white",
  plotTheme = theme_get(),
  vertBars = FALSE,
  plotlyLegend = FALSE,
  expand.y = c(0, 0.05),
  ...
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or file paths}

\item{usePlotly}{\code{logical} Default \code{FALSE} will render using
ggplot. If \code{TRUE} plot will be rendered with plotly}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.}

\item{pattern}{Regex used to trim the end of filenames}

\item{...}{Used to pass additional attributes to theme()}

\item{duplicated}{logical(1). Include deduplicated read total estimates
to plot charts}

\item{bars}{If \code{duplicated = TRUE}, show unique and deduplicated reads
as "stacked" or "adjacent".}

\item{vertBars}{logical(1) Show bars as vertical or horizontal}

\item{divBy}{Scale read totals by this value. The default shows the y-axis
in millions for FastpDataList objects, but does not scale FastQC objects,
for the sake of backwards compatability}

\item{barCols}{Colours for duplicated and unique reads.}

\item{expand.y}{Passed to \code{\link[ggplot2:expansion]{ggplot2::expansion}} for the axis showing totals}

\item{plotlyLegend}{logical(1) Show legend on interactive plots}

\item{adjPaired}{Scale read totals by 0.5 when paired}

\item{scaleFill}{ScaleDiscrete function to be applied to the plot}

\item{labMin}{Only show labels for filtering categories higher than this
values as a proportion of reads. Set to any number > 1 to turn off labels}

\item{status}{logical(1) Include read status in the plot}

\item{labelVJ}{Relative vertical position to labels within each bar.}

\item{labelFill}{Passed to \link[ggplot2]{geom_label}}

\item{plotTheme}{\link[ggplot2]{theme} to be added to the plot}
}
\value{
Returns a ggplot or plotly object
}
\description{
Draw a barplot of read totals
}
\details{
Draw a barplot of read totals using the standard ggplot2 syntax.
The raw data from \code{\link[=readTotals]{readTotals()}} can otherwise be used to manually
create a plot.

Duplication levels are based on the value shown on FASTQC reports at the
top of the DeDuplicatedTotals plot, which is known to be inaccurate.
As it still gives a good guide as to sequence diversity it is included as
the default. This can be turned off by setting \code{duplicated = FALSE}.

For FastpDataList objects, duplication statistics are not part of the
default module containing ReadTotals. However, the status of reads and the
reason for being retained or filtered is, and as such these are shown
instead of duplication statistics.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Plot the Read Totals showing estimated duplicates
plotReadTotals(fdl)

# Plot the Read Totals without estimated duplicates
plotReadTotals(fdl, duplicated = FALSE)

}
