% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isCompressed.R
\name{isCompressed}
\alias{isCompressed}
\title{Check to see if a file is compressed}
\usage{
isCompressed(path, type = c("zip", "gzip"), verbose = FALSE)
}
\arguments{
\item{path}{The path to one or more files}

\item{type}{The type of compression to check for.
Currently only ZIP/GZIP files have been implemented.}

\item{verbose}{logical/integer Determine the level of output to show as
messages}
}
\value{
A \code{logical} vector
}
\description{
Check to see if a file, or vector of files is compressed
}
\details{
Reads the first four bytes from the local file header.
If the file is a .ZIP file, this should match the magic number
\verb{PK\\003\\004}.

This function assumes that the first thing in a zip archive is the
.ZIP entry with the local file header signature.
ZIP files containing a self-extracting archive may not exhibit this structure
and will return FALSE
}
\examples{

# Get the files included with the package
fileDir <- system.file("extdata", package = "ngsReports")
allFiles <- list.files(fileDir, pattern = "zip$", full.names = TRUE)
isCompressed(allFiles)

}
