% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.stats.R
\name{model.stats}
\alias{model.stats}
\title{model.stats}
\usage{
model.stats(models)
}
\arguments{
\item{models}{NetResponse object or list of models}
}
\value{
A 'subnetworks x properties' data frame containing the following elements.
\item{subnet.size: }{ Vector of subnetwork sizes. } \item{subnet.responses:
}{ Vector giving the number of responses in each subnetwork. }
}
\description{
Subnetwork statistics: size and number of distinct responses for each subnet.
}
\examples{
# Load a pre-calculated netresponse model obtained with 
# model <- detect.responses(toydata$emat, toydata$netw, verbose = FALSE)
data(toydata)        
# Calculate summary statistics for the model
stat <- model.stats(toydata$model)


}
\references{
Leo Lahti et al.: Global modeling of transcriptional responses
in interaction networks. Bioinformatics (2010).  See citation('netresponse')
for reference details.
}
\author{
Leo Lahti <leo.lahti@iki.fi>
}
\keyword{utilities}
