% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot.R
\name{dot_plot}
\alias{dot_plot}
\title{Create a plot showing the edges with the highest partial correlation in any cluster.}
\usage{
dot_plot(net.clustering, p.corrs.thresh = 0.25, hard.limit = 50,
  display = TRUE, node.names = rownames(net.clustering$Mu),
  group.names = sort(unique(net.clustering$comp)),
  dot.size.range = c(3, 12))
}
\arguments{
\item{net.clustering}{A network clustering object as returned by 
\code{\link{het_cv_glasso}} or \code{\link{mixglasso}}.}

\item{p.corrs.thresh}{Cutoff for the partial correlations; only edges with absolute 
partial correlation > p.corrs.thresh (in any cluster) will be displayed.}

\item{hard.limit}{Additional hard limit on the number of edges to display. If 
p.corrs.thresh results in more edges than hard.limit, only hard.limit edges with the
highest partial correlation are returned.}

\item{display}{If TRUE, print the plot to the current output device.}

\item{node.names}{Names for the nodes in the network.}

\item{group.names}{Names for the clusters or groups.}

\item{dot.size.range}{Graphical parameter for scaling the size of the circles (dots)
representing an edge in each cluster.}
}
\value{
Returns a ggplot2 object. If display=TRUE, additionally displays the 
plot.
}
\description{
This function takes the output of \code{\link{het_cv_glasso}} or 
\code{\link{mixglasso}} and creates a plot of the highest scoring edges along the
y axis, where, the edge in each cluster is represented by a circle whose area
is proportional to the smallest mean of the two nodes that make up the edge,
and the position along the y axis shows the partial correlation of the edge.
}
\examples{
n = 500
p = 10
s = 0.9
n.comp = 3

# Create different mean vectors
Mu = matrix(0,p,n.comp)

# Define non-zero means in each group (non-overlapping)
nonzero.mean = split(sample(1:p),rep(1:n.comp,length=p))

# Set non-zero means to fixed value
for(k in 1:n.comp){
	Mu[nonzero.mean[[k]],k] = -2/sqrt(ceiling(p/n.comp))
}

# Generate data
sim.result = sim_mix_networks(n, p, n.comp, s, Mu=Mu)
mixglasso.result = mixglasso(sim.result$data, n.comp=3)
mixglasso.clustering = mixglasso.result$models[[mixglasso.result$bic.opt]]

dot_plot(mixglasso.clustering, p.corrs.thresh=0.5)
}
