% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nempi_main.r
\name{plotConvergence.nempi}
\alias{plotConvergence.nempi}
\title{Plot convergence of EM}
\usage{
\method{plotConvergence}{nempi}(x, type = "b", ...)
}
\arguments{
\item{x}{nempi object}

\item{type}{see ?plot.default}

\item{...}{additional parameters for plot}
}
\value{
plot
}
\description{
Produces different convergence plots based on a nempi object
}
\examples{
D <- matrix(rnorm(1000*100), 1000, 100)
colnames(D) <- sample(seq_len(5), 100, replace = TRUE)
Gamma <- matrix(sample(c(0,1), 5*100, replace = TRUE, p = c(0.9, 0.1)), 5,
100)
Gamma <- apply(Gamma, 2, function(x) return(x/sum(x)))
Gamma[is.na(Gamma)] <- 0
rownames(Gamma) <- seq_len(5)
result <- nempi(D, Gamma = Gamma)
par(mfrow=c(2,3))
plotConvergence(result)
}
\author{
Martin Pirkl
}
