% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nempi_main.r
\name{plot.nempi}
\alias{plot.nempi}
\title{Plotting nempi}
\usage{
\method{plot}{nempi}(x, barlist = list(), heatlist = list(), ...)
}
\arguments{
\item{x}{object of class 'nempi'}

\item{barlist}{additional arguments for function 'barplot' from
package 'graphics'}

\item{heatlist}{additional arguments for function 'HeatmapOP'
from package 'epiNEM'}

\item{...}{additional arguments for function 'plotDnf' from package 'mnem'}
}
\value{
Plots of the optimal network phi and perturbation matrix.
}
\description{
Plot function for an object of class 'nempi'.
}
\examples{
D <- matrix(rnorm(1000*100), 1000, 100)
colnames(D) <- sample(seq_len(5), 100, replace = TRUE)
result <- nempi(D)
plot(result)
}
\author{
Martin Pirkl
}
