% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractTranscriptomeSequence.R
\name{ExtractTranscriptomeSequence}
\alias{ExtractTranscriptomeSequence}
\title{ExtractTranscriptomeSequence}
\usage{
ExtractTranscriptomeSequence(
  transcript_list,
  ref_genome,
  genome_gtf,
  RNA_fragment = "exon",
  exome_prefix = "exome"
)
}
\arguments{
\item{transcript_list}{A vector of transcript names that represent the most
expressed isoform of their respective genes and correspond to GTF annotation
names. Required}

\item{ref_genome}{The name of the reference genome FASTA from which exome
sequences will be derived; a string. Required}

\item{genome_gtf}{The name of the GTF/GFF file that contains all exome
annotations; a string. Coordinates must match the file input for the
ref_genome parameter. Required}

\item{RNA_fragment}{A string of RNA component of interest. Options depend on
the gtf file but often include "gene", "transcript", "exon", "CDS",
"five_prime_utr", and/or "three_prime_utr". Default "exon" for the whole
exome.}

\item{exome_prefix}{A string to add to the prefix for all output files.
Default "exome"}
}
\value{
writes FASTA file of transcriptome sequences into directory
}
\description{
Writes a FASTA file of transcript sequences from a list of
transcripts.
}
\note{
transcript_list, genome_gtf, and RNA_fragment arguments should be the
same as GenomeMappingToChainFile function arguments
}
\examples{
\donttest{
## load transcript list
load(system.file("extdata/transcript_list.Rda", package="nearBynding"))
##get GTF file
gtf<-system.file("extdata/Homo_sapiens.GRCh38.chr4&5.gtf",
                 package="nearBynding")
ExtractTranscriptomeSequence(transcript_list = transcript_list,
             ref_genome = "Homo_sapiens.GRCh38.dna.primary_assembly.fa",
             genome_gtf = gtf,
             RNA_fragment = "three_prime_utr",
             exome_prefix = "chr4and5_3UTR")
}

}
