% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_show_permission}
\alias{ndex_user_show_permission}
\title{Get User's Permission for Network}
\usage{
ndex_user_show_permission(ndexcon, userId, networkId, directonly = FALSE)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID (UUID) of the user}

\item{networkId}{character; unique ID (UUID) of the group}

\item{directonly}{logical (default: FALSE); If directonly is set to true, permissions granted through groups are not included in the result}
}
\value{
List of permissions of that user ("READ"|"WRITE"|"ADMIN") or empty object
}
\description{
Get the type(s) of permission assigned to the authenticated user for the specified network. Returns a map which maps a network UUID to the highest permission assigned to the authenticated user.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$permission$get
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## get user by name to get UUID
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## get users's permission to a network
# networkPermissions = ndex_user_show_permission(ndexcon, userId, networkId, directonly=TRUE)
## $`nnneeett-wwww-oooo-rrrr-kkkkkkk11111`
## [1] "ADMIN"
NULL
}
\seealso{
\link{ndex_network_get_permission}
}
