% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_ndex_properties.r
\name{ndex_network_delete_permission}
\alias{ndex_network_delete_permission}
\title{Delete Network Permission}
\usage{
ndex_network_delete_permission(ndexcon, networkId, user = NULL, group = NULL)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}

\item{user}{character (optional); uuid of the user. Only either user or group may be set!}

\item{group}{character (optional); uuid of the group. Only either user or group may be set!}
}
\value{
1 integer on success, 0 if user/group allready has no permissions on the network
}
\description{
Removes any permission for the network for the user or group specified
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 1.3 and 2.0

In version 1.3 the function only works for user permissions!
}
\section{REST query}{

GET: ndex_config$api$network$permission$delete
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find one of your networks and get its UUID
# networks = ndex_find_networks(ndexcon, accountName='MyAccountName')
# networkId = networks[1,"externalId"]
## Get the UUID for a user and group
# someUserUuid = "uuuuuuuu-ssss-eeee-rrrr-111111111111"
# someGroupUuid = "ggggggg-rrrr-oooo-uuuu-pppppppppppp"
## Delete the permissions
#ndex_network_delete_permission(ndexcon, networkId, user=someUserUuid)
# => returns 1
#ndex_network_delete_permission(ndexcon, networkId, user=someUserUuid)
# => returns 0, because user already lost permission on network
#ndex_network_delete_permission(ndexcon, networkId, group=someGroupUuid)
NULL
}
