% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateFitnessScore.R
\name{calculateFitnessScore}
\alias{calculateFitnessScore}
\title{Calculate fitness scores.}
\usage{
calculateFitnessScore(
  se,
  pairingCol,
  ODCols,
  comparison,
  WTrows,
  selAssay = "counts"
)
}
\arguments{
\item{se}{SummarizedExperiment object as returned by 
\code{\link{summarizeExperiment}}.}

\item{pairingCol}{Name of column in \code{colData(se)} with 
replicate/pairing information. Samples with the same value in this 
column will be paired.}

\item{ODCols}{Name(s) of column(s) in \code{colData(se)} with OD values 
(numeric), used to normalize for different numbers of cells.}

\item{comparison}{3-element character vector of the form 
\code{(column, numerator, denominator)}. \code{column} is the name of 
the column in \code{colData(se)} with experimental conditions. 
\code{numerator} and \code{denominator} define the comparison, 
e.g. \code{c("cond", "output", "input")} will look in the 
\code{"cond"} column and calculate fitness for the ratio of 
\code{"output"} over \code{"input"} counts.}

\item{WTrows}{Vector of row names that will be used as the reference when
calculating fitness scores. If more than one value is provided, the 
average of the corresponding fitness scores is used as a reference. 
If NULL, no division by WT scores will be done.}

\item{selAssay}{Assay to select from \code{se} for the analysis.}
}
\value{
A numeric vector with fitness scores.
}
\description{
Using sequence counts before and after selection, calculate fitness scores 
as described by Diss and Lehner (2018).
}
\examples{
se <- readRDS(system.file("extdata", "GSE102901_cis_se.rds", 
                          package = "mutscan"))
## Check that the wildtype sequence is present in the data
stopifnot("f.0.WT" \%in\% rownames(se))
## Calculate PPI scores as defined in Diss & Lehner (2018)
ppis <- calculateFitnessScore(
    se = se, pairingCol = "Replicate", 
    ODCols = c("OD1", "OD2"),
    comparison = c("Condition", "cis_output", "cis_input"),
    WTrows = "f.0.WT")
## Matrix with PPI scores for each replicate
head(ppis)

}
\references{
"The genetic landscape of a physical interaction."
    Diss G and Lehner B. Elife. 2018;7:e32472. doi: 10.7554/eLife.32472.
}
\author{
Michael Stadler and Charlotte Soneson
}
