% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{plot_umap}
\alias{plot_umap}
\title{Plot a UMAP from a musica result}
\usage{
plot_umap(
  musica,
  model_name,
  modality = "SBS96",
  result_name = "result",
  color_by = c("signatures", "annotation", "cluster", "none"),
  proportional = TRUE,
  annotation = NULL,
  point_size = 0.7,
  same_scale = TRUE,
  add_annotation_labels = FALSE,
  annotation_label_size = 3,
  annotation_text_box = TRUE,
  plotly = FALSE,
  clust = NULL,
  legend = TRUE,
  strip_axes = FALSE
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object containing a mutational
signature discovery or prediction.}

\item{model_name}{The name of the desired model.}

\item{modality}{The modality of the model. Must be "SBS96", "DBS78", or
"IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing the model.Default
\code{"result"}.}

\item{color_by}{One of \code{"signatures"}, \code{"annotation"}, or
\code{"none"}. If \code{"signatures"}, then one UMAP scatterplot will be
generated for each signature and points will be colored by the level of
that signature in each sample. If \code{annotation}, a single UMAP will
be generated colored by the annotation selected using the parameter
\code{annotation}. If \code{"none"}, a single UMAP scatterplot will be
generated with no coloring. Default \code{"signature"}.}

\item{proportional}{If \code{TRUE}, then the exposures will be normalized
to between 0 and 1 by dividing by the total number of counts for each sample.
Default \code{TRUE}.}

\item{annotation}{Sample annotation used to color the points. One used
when \code{color_by = "annotation"}. Default \code{NULL}.}

\item{point_size}{Scatter plot point size. Default \code{0.7}.}

\item{same_scale}{If \code{TRUE}, then all points will share the same color
scale in each signature subplot. If \code{FALSE}, then each signature subplot
will be colored by a different scale with different maximum values. Only
used when \code{color_by = "signature"}. Setting to \code{FALSE} is most
useful when the maximum value of various signatures are vastly different
from one another. Default \code{TRUE}.}

\item{add_annotation_labels}{If \code{TRUE}, labels for each group in the
\code{annotation} variable will be displayed. Only used if
\code{color_by = "annotation"}. This not recommended if the annotation is
a continuous variable. The label is plotting using the centriod of each
group within the \code{annotation} variable. Default \code{FALSE}.}

\item{annotation_label_size}{Size of annotation labels. Only used if
\code{color_by = "annotation"} and \code{add_annotation_labels = TRUE}.
Default \code{3}.}

\item{annotation_text_box}{Place a white box around the annotation labels
to improve readability. Only used if \code{color_by = "annotation"} and
\code{add_annotation_labels = TRUE}. Default \code{TRUE}.}

\item{plotly}{If \code{TRUE}, the the plot will be made interactive
using \code{\link[plotly]{plotly}}. Not used if \code{color_by = "signature"}
and \code{same_scale = FALSE}. Default \code{FALSE}.}

\item{clust}{Add cluster labels as annotation}

\item{legend}{Plot legend}

\item{strip_axes}{Remove axes labels for cleaner looking plots}
}
\value{
Generates a ggplot or plotly object
}
\description{
Plots samples on a UMAP scatterplot. Samples can be colored by
the levels of mutational signatures or by a annotation variable.
}
\examples{
data(res_annot)
create_umap(res_annot, "res_annot")
plot_umap(res_annot, "res_annot", color_by = "none")
}
\seealso{
See \link{create_umap} to generate a UMAP in a musica result.
}
