% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery_prediction.R
\name{generate_result_grid}
\alias{generate_result_grid}
\title{Generate result_grid from musica based on annotation and range of k}
\usage{
generate_result_grid(
  musica,
  modality,
  algorithm = "lda",
  annotation = NA,
  k_start,
  k_end,
  result_name = "result_grid",
  n_start = 1,
  seed = NULL,
  par_cores = FALSE,
  verbose = FALSE,
  make_copy = FALSE,
  table_name = NULL
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{modality}{Modality used for signature discovery}

\item{algorithm}{Algorithm for signature discovery}

\item{annotation}{Sample annotation to split results into}

\item{k_start}{Lower range of number of signatures for discovery}

\item{k_end}{Upper range of number of signatures for discovery}

\item{result_name}{Name for result_list entry to save the results to. Default
\code{"result_grid"}.}

\item{n_start}{Number of times to discover signatures and compare based on
posterior loglikihood}

\item{seed}{Seed to use for reproducible results, set to null to disable}

\item{par_cores}{Number of parallel cores to use (NMF only)}

\item{verbose}{Whether to output loop iterations}

\item{make_copy}{If \code{FALSE}, the inputted \code{\linkS4class{musica}}
object is updated and nothing is returned. If \code{TRUE}, a new
\code{\linkS4class{musica}} object is created and returned. Default
\code{FALSE}.}

\item{table_name}{Use modality instead}
}
\value{
Returns nothing or a new \code{\linkS4class{musica}} object,
depending on the \code{make_copy} parameter.
}
\description{
Generate result_grid from musica based on annotation and range of k
}
\examples{
data(musica_sbs96)
grid <- generate_result_grid(musica_sbs96, "SBS96", "lda",
  k_start = 2,
  k_end = 5
)
}
