% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_musica.R
\name{sample_names}
\alias{sample_names}
\alias{sample_names,musica-method}
\title{Retrieve sample names from a musica object}
\usage{
sample_names(object)

\S4method{sample_names}{musica}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{musica}} object generated by
the \link{create_musica_from_variants} or \link{create_musica_from_counts}
function.}
}
\value{
A character vector of sample names
}
\description{
Sample names were included in the \code{sample} column
in the variant object passed to \code{\link{create_musica_from_variants}}, or
in the colnames of the count table object passed to
\code{\link{create_musica_from_counts}}. This returns a unique list of
samples names in the order they are inside the \code{\linkS4class{musica}}
object.
}
\examples{
data(res)
sample_names(res)
}
