% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{extract_variants_from_vcf_file}
\alias{extract_variants_from_vcf_file}
\title{Extracts variants from a vcf file}
\usage{
extract_variants_from_vcf_file(
  vcf_file,
  id = NULL,
  rename = NULL,
  sample_field = NULL,
  filename_as_id = FALSE,
  strip_extension = c(".vcf", ".vcf.gz", ".gz"),
  filter = TRUE,
  multiallele = c("expand", "exclude"),
  extra_fields = NULL,
  fix_vcf_errors = TRUE
)
}
\arguments{
\item{vcf_file}{Path to the vcf file}

\item{id}{ID of the sample to select from VCF. If \code{NULL}, then the
first sample will be selected. Default \code{NULL}.}

\item{rename}{Rename the sample to this value when extracting variants.
If \code{NULL}, then the sample will be named according to \code{ID}.}

\item{sample_field}{Some algoriths will save the name of the
sample in the ##SAMPLE portion of header in the VCF (e.g.
##SAMPLE=<ID=TUMOR,SampleName=TCGA-01-0001>). If the ID is specified via the
\code{id} parameter ("TUMOR" in this example), then \code{sample_field} can
be used to specify the name of the tag ("SampleName" in this example).
Default \code{NULL}.}

\item{filename_as_id}{If set to \code{TRUE}, the file name will be used
as the sample name.}

\item{strip_extension}{Only used if \code{filename_as_id} is set to
\code{TRUE}. If set to \code{TRUE}, the file extention will be stripped
from the filename before setting the sample name.
If a character vector is given, then all the strings
in the vector will removed from the end of the filename before setting the
sample name. Default \code{c(".vcf",".vcf.gz",".gz")}}

\item{filter}{Exclude variants that do not have a \code{PASS} in the
\code{FILTER} column of the VCF. Default \code{TRUE}.}

\item{multiallele}{Multialleles are when multiple alternative variants
are listed in the same row in the vcf. One of \code{"expand"} or
\code{"exclude"}. If \code{"expand"} is selected, then each
alternate allele will be given their own rows. If \code{"exclude"} is
selected, then these rows will be removed. Default \code{"expand"}.}

\item{extra_fields}{Optionally extract additional fields from the \code{INFO}
section of the VCF. Default \code{NULL}.}

\item{fix_vcf_errors}{Attempt to automatically fix VCF file
formatting errors.}
}
\value{
Returns a data.table of variants extracted from a vcf
}
\description{
Add Description
}
\examples{
vcf <- system.file("extdata", "public_LUAD_TCGA-97-7938.vcf",
  package = "musicatk"
)
variants <- extract_variants_from_vcf_file(vcf_file = vcf)
}
