% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_estimate.R
\name{qtleParams}
\alias{qtleParams}
\title{Default qtle simulation parameters}
\usage{
qtleParams()
}
\value{
A list with the default parameter values which can be used when simulating multistateQTL
  data.
}
\description{
Returns a list of the default values used for parameters when 
simulating multistateQTL data. Parameters include:
\itemize{
  \item betas.sig.shape
  \item betas.sig.rate
  \item cv.sig.shape
  \item cv.sig.rate
  \item betas.null.shape
  \item betas.null.rate
  \item cv.null.shape
  \item cv.null.rate
}
}
\details{
The default parameters returned by this function were generated 
using expression QTL (eQTL) summary statistics from the 
\href{https://www.gtexportal.org/home/}{Genotype-Tissue Expression
(GTEx) Project} (Version 8) for the ten tissues with the largest sample 
sizes for eQTL mapping. The eQTL tests were filtered to include only
eQTLs on chromosome 1 that were available in all 10 tissues.

\code{qtleParams()} returns the parameters used for the plots in the vignette.
\code{qtleParams2()} returns the parameter values 
from the 'Orchestrating multi-state QTL analysis with R' manuscript
and accompanying reproducible analysis workflow (see 
\href{https://gitlab.svi.edu.au/biocellgen-public/WEEO_2022_multistateQTL}{
WEEO_2022_multistateQTL}).
}
\examples{
qtleParams()

}
