% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSignificantFeatures.R
\name{runSignificantFeatures}
\alias{runSignificantFeatures}
\title{Function to summarize QTL summary statistics by feature ID}
\usage{
runSignificantFeatures(object, assay = "significant")
}
\arguments{
\item{object}{A \linkS4class{QTLExperiment} object with multiple
QTL tests (i.e., rows) for at least one feature.}

\item{assay}{Assay containing T/F significance calls for each test.}
}
\value{
The `QTLExperiment` object with a summary of significant features in 
the metadata and a new column `nSignificantFeatures` in the colData.
}
\description{
This function adds a summary of the features with significant QTL in each 
state to the metadata of the QTLExperiment object.
}
\examples{

qtle <- mockQTLE()

qtle <- callSignificance(qtle)

# There is an assay called 'significant'
assays(qtle)

# Obtain summary of significant features for each state
qtle <- runSignificantFeatures(qtle)

# There is a summary added to the metadata of the object
metadata(qtle)

}
