% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotUpSet}
\alias{plotUpSet}
\title{Upset plot of QTL sharing between states with state-level annotations}
\usage{
plotUpSet(
  object,
  assay = "significant",
  name = "colnames",
  minShared = 10,
  minDegree = 2,
  maxDegree = NULL,
  annotateColsBy = NULL,
  comb_order = "comb_size",
  set_order = order(ss),
  ...
)
}
\arguments{
\item{object}{an \code{QTLExperiment} object}

\item{assay}{Name of assay to use to assess significance.}

\item{name}{character specifying the column in colData to use to label rows
and columns. Default is colnames(qtle).}

\item{minShared}{minimum number of shared QTL for set to be included.}

\item{minDegree}{minimum degree of sharing for set to be included.}

\item{maxDegree}{maximum degree of sharing for set to be included.}

\item{annotateColsBy}{character or array of characters specifying the
column(s) in colData to be plotted as annotations.}

\item{comb_order}{characters specifying how sets should be ordered. Options
include the set size (set_size), combination size (comb_size), degree (deg).}

\item{set_order}{Array specifying order of states.}

\item{...}{Further arguments passed to \code{\link[ComplexHeatmap]{UpSet}}}
}
\value{
Returns a \code{ComplexHeatmap} object.
}
\description{
Convenient method to plot an UpSet plot showing the number of QTL that are
significant in sets of states.
}
\examples{
sim <- qtleSimulate(
    nStates=10, nFeatures=100, nTests=1000,
    global=0.2, multi=0.4, unique=0.2, k=2)
sim <- callSignificance(sim, mode="simple", assay="lfsrs", 
    thresh=0.0001, secondThresh=0.0002)
sim_sig <- getSignificant(sim)
sim_top <- getTopHits(sim_sig, assay="lfsrs", mode="state")
sim_top <- runPairwiseSharing(sim_top)

plotUpSet(sim_top)

# Upset plot with complex row annotations
plotUpSet(sim_top, annotateColsBy = c("nSignificant", "multistateGroup"))
}
