% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotQTLClusters}
\alias{plotQTLClusters}
\title{Heatmap of QTL across states}
\usage{
plotQTLClusters(
  object,
  fillBy = "betas",
  FUN = identity,
  minSig = 1,
  annotateColsBy = NULL,
  annotateRowsBy = NULL,
  show_row_names = FALSE,
  state_id = "state_id",
  columnOrder = NULL,
  rowOrder = NULL,
  row_km = 0,
  column_km = 0,
  ...
)
}
\arguments{
\item{object}{an \code{QTLExperiment} object.}

\item{fillBy}{name of assay to use for main heatmap object.}

\item{FUN}{Function to be applied to fillBy assay before plotting (e.g.
identity, abs, log10).}

\item{minSig}{minimum number of significant states for QTL to be included.}

\item{annotateColsBy}{character or array of characters specifying the
column(s) in colData to be plotted to annotate states.}

\item{annotateRowsBy}{character or array of characters specifying the
column(s) in rowData to be plotted to annotate QTL tests.}

\item{show_row_names}{Logical to plot row (i.e. test) names.}

\item{state_id}{colData column to use to label states.}

\item{columnOrder}{Null for clustering or array to overwrite state order}

\item{rowOrder}{Null for clustering or array to overwrite test order}

\item{row_km}{Set k for k-means clustering of tests.}

\item{column_km}{Set k for k-means clustering of states}

\item{...}{Further arguments passed to \code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
Returns a \code{ComplexHeatmap} object.
}
\description{
Convenience method for plotting values from any assay specified by fillBy
across states and tests.
}
\examples{
sim <- qtleSimulate(
    nStates=10, nFeatures=100, nTests=1000,
    global=0.2, multi=0.4, unique=0.2, k=2)
sim <- callSignificance(sim, mode="simple", assay="lfsrs", 
    thresh=0.0001, secondThresh=0.0002)
    
sim_sig <- getSignificant(sim)
sim_top <- getTopHits(sim_sig, assay="lfsrs", mode="state")
sim_top <- runTestMetrics(sim_top)
sim_top <- runPairwiseSharing(sim_top)
sim_top_ms <- subset(sim_top, qtl_type_simple == "multistate")

plotQTLClusters(sim_top)

# Plot with annotations for multi state group
plotQTLClusters(sim_top_ms, annotateColsBy = c("multistateGroup"),
    annotateRowsBy = c("qtl_type", "mean_beta", "QTL"))

}
