% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/callSignificance.R
\name{callSignificance}
\alias{callSignificance}
\alias{callSignificance<-}
\alias{callSignificance,QTLExperiment-method}
\title{Call associations as significant in each state.}
\usage{
callSignificance(object, ...)

callSignificance(object, ...) <- value

\S4method{callSignificance}{QTLExperiment}(
  object,
  thresh = 0.05,
  secondThresh = thresh,
  feature = .feature_id,
  assay = "pvalues",
  mode = "simple",
  p.adjust.method = "fdr",
  ...
)
}
\arguments{
\item{object}{A \linkS4class{QTLExperiment} object.}

\item{...}{arguments passed to \code{callSignificance}}

\item{value}{Value to place in getSignificance}

\item{thresh}{Significance threshold.}

\item{secondThresh}{Significance threshold for associations with significance in one state.}

\item{feature}{rowData column name with feature identifier.}

\item{assay}{assay name with significance score.}

\item{mode}{Method to determine significance threshold per state. Options are
`simple`, `feature-wise-FDR`, and `global-FDR`.}

\item{p.adjust.method}{Method of multiple-test correction if mode != simple}
}
\value{
A `QTLExperiment` object with a new assay called `significant` and with
a column called nSignificant added to the colData.
}
\description{
Call associations as significant in each state.
}
\details{
This function adds a new assay to multistateQTL object with TRUE/FALSE
significance calls for each test for each state.
}
\examples{
qtle <- mockQTLE()

assays(qtle)
qtle <- callSignificance(qtle)

# There is now an assay called 'significant'
assays(qtle)

# Use feature-wise FDR correction -------------------------------------------
qtle_feat <- callSignificance(qtle, thresh=0.1, mode="feature-wise-FDR")

}
\seealso{
\code{\link{wilcox.test}}, on which this function is based.
}
\author{
Christina B Azodi
}
