% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_bed_to_granges.R
\name{bed_to_granges}
\alias{bed_to_granges}
\title{Read bedfile into GRanges}
\usage{
bed_to_granges(
  bedfile,
  genome,
  txdb = NULL,
  do_order = TRUE,
  plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{bedfile}{file path}

\item{genome}{string: UCSC genome name (e.g. 'mm10')}

\item{txdb}{NULL (default) or \code{\link[GenomicFeatures]{TxDb-class}}
(used for gene annotation)}

\item{do_order}{TRUE (default) or FALSE: order on seqnames and star?}

\item{plot}{TRUE (default) or FALSE: plot karyogram?}

\item{verbose}{TRUE (default) or FALSE}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Read bedfile into GRanges
}
\examples{
bedfile  <- system.file('extdata/SRF.bed', package = 'multicrispr')
bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
(gr <- bed_to_granges(bedfile, genome='mm10'))
}
\seealso{
\code{\link{char_to_granges}}, \code{\link{genes_to_granges}}
}
