% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_manipulate_ranges.R
\name{add_seq}
\alias{add_seq}
\title{Add sequence to GRanges}
\usage{
add_seq(gr, bsgenome, verbose = FALSE, as.character = TRUE)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{bsgenome}{\code{\link[BSgenome]{BSgenome-class}}}

\item{verbose}{TRUE or FALSE (default)}

\item{as.character}{TRUE (default) or FALSE}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}
}
\description{
Add sequence to GRanges
}
\examples{
# PE example
#-----------
    require(magrittr)
    bsgenome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38  
    gr <- char_to_granges(c(PRNP = 'chr20:4699600:+',             # snp
                            HBB  = 'chr11:5227002:-',             # snp
                            HEXA = 'chr15:72346580-72346583:-',   # del
                            CFTR = 'chr7:117559593-117559595:+'), # ins
                          bsgenome)
   (gr \%<>\% add_seq(bsgenome))
   
# TFBS example
#-------------
    bsgenome <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
    bedfile  <- system.file('extdata/SRF.bed', package='multicrispr')
    gr <- bed_to_granges(bedfile, 'mm10')
    (gr \%<>\% add_seq(bsgenome))
}
