% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbversion.R
\name{multimir_switchDBVersion}
\alias{multimir_switchDBVersion}
\title{Manage Database Version to use}
\usage{
multimir_switchDBVersion(db_version, url = NULL)
}
\arguments{
\item{db_version}{A character string containing the full version number for
the database version to use for for all package functions. The default will
be the most recent version.}

\item{url}{Deprecated. Use global option \code{multimir.url} instead.}
}
\value{
\code{multimir_dbInfoVersions}: a data frame with information about the
multiMiR database versions.

\code{multimir_switchDBVersion}: none (invisible \code{NULL}).
}
\description{
Functions for managing the database version used to complete requests on the
web server.
}
\details{
\code{url} is a character string containing the URL of the multiMiR web
server. Optional as it is set when the package is loaded.

\code{multimir_dbInfoVersions} returns other information about the multiMiR
database versions available. This provides a list of available options if
switching to previous version is desired.

\code{multimir_switchDBVersion} returns other information about the multiMiR
database versions available. This provides a list of available options if
switching to previous version is desired.
}
\examples{

  multimir_dbInfoVersions()
  multimir_switchDBVersion(db_version="2.0.0")

}
\keyword{database}
\keyword{utilities}
