% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{hic_glm}
\alias{hic_glm}
\title{Function to perform GLM differential analysis on Hi-C experiment}
\usage{
hic_glm(
  hicexp,
  design,
  contrast = NA,
  coef = NA,
  method = "QLFTest",
  M = 1,
  p.method = "fdr",
  parallel = FALSE,
  max.pool = 0.7
)
}
\arguments{
\item{hicexp}{A hicexp object,}

\item{design}{A design matrix for the GLM.}

\item{contrast}{Numeric vector or matrix specifying one or more 
contrasts of the linear model coefficients to be tested 
equal to zero.}

\item{coef}{integer or character index vector indicating which 
coefficients of the linear model are to be tested equal to zero.}

\item{method}{The test method to be performed. Should be one of
"QLFTest", "LRTest", or "Treat".}

\item{M}{The log2 fold change value for a TREAT analysis.}

\item{p.method}{p-value adjustment method to be used. Defaults
to "fdr". See ?p.adjust for other adjustment options.}

\item{parallel}{Logical, Should parallel processing be used?}

\item{max.pool}{The proportion of unit distances after
which all further distances will be pooled. Distances
before this value will be progressively pooled and
any distances after this value will be combined
into a single pool. Defaults to 0.7. Warning: do
not adjust this value from the default unless you
are getting errors related to the lfproc function
or due to sparsity in fastlo normalization. If these
errors occur it is due to either sparsity or low 
variance and max.pool will need to be lowered; 
typically to 0.5 or 0.6.}
}
\value{
A hicexp object with a filled in comparison slot.
}
\description{
Function to perform GLM differential analysis on Hi-C experiment
}
\details{
This function performs the specified edgeR GLM based test
    on a per distance basis on the Hi-C data. Distances groups
    are pooled using "progressive pooling". There are 3 options
    for the type of GLM based test to be used which is specified
    with the method option. \cr
    \code{QLFTest} will use edgeR's glmQLFit and glmQLFTest functions which
    makes use of quasi-likelihood methods described in Lund
    et al (2012). \cr
    \code{LRTest} uses edgeR's glmFit and glmLRT functions which uses
    a interaction-wise negative binomial general linear model.
    This method uses a likelihood ratio test for the coefficients
    specified in the model. \cr
    \code{Treat} uses edgeR's glmTreat function which performs a test
    for differential expression with a minimum required fold-change
    threshold imposed. It tests whether the absolute value of the 
    log2 fold change is greater than the value specified as the \code{M}
    option.
}
\examples{
\dontrun{
data("hicexp_diff")
d <- model.matrix(~factor(meta(hicexp_diff)$group) + factor(c(1,2,1,2)))
hicexp_diff <- hic_glm(hicexp_diff, design = d, coef = 2)}

}
