% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_processing.R
\name{getGeneMapping}
\alias{getGeneMapping}
\title{Mapping between pathway encoded genes/proteins and different ID formats.}
\usage{
getGeneMapping(features, keytype, org = "hsapiens", returntype = "SYMBOL")
}
\arguments{
\item{features}{List of identifiers to be mapped.}

\item{keytype}{String specifying the ID type, e.g., "ENTREZID" or "UNIPROT".}

\item{org}{String that defines the organism. Default: hsapiens
Options: see \code{\link[multiGSEA]{getOrganisms}}}

\item{returntype}{String that specifies the returning ID type. Default:
SYMBOL, Options: SYMBOL, ENTREZID, UNIPROT, ENSEMBL, REFSEQ}
}
\value{
List containing mapped gene/protein IDs.
}
\description{
Function to retrieve the gene/protein identifier mapping. Ongoing from
genes/proteins retrieved from pathway definitions, which often include two or
more ID formats or a format that is not present in your omics measurement,
this function maps those IDs to a given format. Depending on the organism,
additional packages have to be installed.
}
\examples{
features <- graphite::nodes(graphite::pathways("hsapiens", "kegg")[[1]])
features <- gsub("ENTREZID:", "", features)
keytype <- "ENTREZID"
getGeneMapping(features, keytype)

getGeneMapping(features, keytype, returntype = "UNIPROT")
\donttest{
features <- graphite::nodes(graphite::pathways("rnorvegicus", "reactome")[[1]])
features <- gsub("UNIPROT:", "", features)
getGeneMapping(features, keytype = "UNIPROT", org = "rnorvegicus")

getGeneMapping(features,
  keytype = "UNIPROT",
  org = "rnorvegicus",
  returntype = "ENSEMBL"
)
}

}
