% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_processing.R
\name{getFeatures}
\alias{getFeatures}
\title{Wrapper to extract features (nodes) from given pathways.}
\usage{
getFeatures(
  pathway,
  which = "proteins",
  org = "hsapiens",
  returntype = "SYMBOL"
)
}
\arguments{
\item{pathway}{A pathway created with \code{\link[graphite:pathways]{pathways}} command.}

\item{which}{Mode to extract the features, either \'proteins\' or
\'metabolites\'.}

\item{org}{String specifying the organism, which is necessary for featureID
mapping. Default: human}

\item{returntype}{String that specifies the returning ID type. Default:
SYMBOL Options (genes/proteins): SYMBOL, ENTREZID, UNIPROT, ENSEMBL, REFSEQ
Options (metabolites): HMDB, CAS, DTXCID, DTXSID, SID, CID, ChEBI, KEGG, Drugbank}
}
\value{
Feature list with gene symbols (genes/proteins) or CHEBI IDs
  (metabolites)
}
\description{
Function to extract the features (nodes) from a given list of pathways. These
pathways have to be compiled with the
\code{\link[graphite:pathways]{pathways}} function. Features can only be
extracted for \'proteins\' or \'metabolites\'. Features will by default be
mapped to gene symbols.
}
\examples{
pathways <- graphite::pathways("hsapiens", "kegg")[[1]]
getFeatures(pathways)
\donttest{
pathways <- graphite::pathways("mmusculus", "kegg")[[1]]
getFeatures(pathways, which = "metabolites", org = "mmusculus", returntype = "HMDB")

pathways <- graphite::pathways("mmusculus", "kegg")[[1]]
getFeatures(pathways, which = "proteins", org = "mmusculus", returntype = "SYMBOL")
}

}
