% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_peaks.R
\name{prepare_peaks}
\alias{prepare_peaks}
\title{prepare_peaks
Prepare a label free quantification file exported from PEAKS
for subsequent mspms analysis.}
\usage{
prepare_peaks(
  lfq_filepath,
  colData_filepath,
  quality_threshold = 0.3,
  peptide_library = mspms::peptide_library,
  n_residues = 4
)
}
\arguments{
\item{lfq_filepath}{this is the file path to a .csv file exported from
PEAKS}

\item{colData_filepath}{file path to .csv file containing colData.
Must have columns named "quantCols","group","condition",and "time".}

\item{quality_threshold}{only consider peptides with quality scores > than
this threshold.}

\item{peptide_library}{peptide library used in the experiment.}

\item{n_residues}{the number of amino acid residues before and after the
cleavage site to generate a cleavage seq for.}
}
\value{
a QFeatures object containing a summarizedExperiment named "peptides"
}
\description{
prepare_peaks
Prepare a label free quantification file exported from PEAKS
for subsequent mspms analysis.
}
\examples{
lfq_filepath <- system.file("extdata/peaks_protein-peptides-lfq.csv", package = "mspms")
colData_filepath <- system.file("extdata/colData.csv", package = "mspms")
# Prepare the data
peaks_prepared_data <- mspms::prepare_peaks(lfq_filepath, colData_filepath)
}
